/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.container.ogg;

import com.sedmelluq.discord.lavaplayer.container.MediaContainerDetection;
import com.sedmelluq.discord.lavaplayer.container.MediaContainerDetectionResult;
import com.sedmelluq.discord.lavaplayer.container.MediaContainerHints;
import com.sedmelluq.discord.lavaplayer.container.MediaContainerProbe;
import com.sedmelluq.discord.lavaplayer.container.ogg.OggAudioTrack;
import com.sedmelluq.discord.lavaplayer.container.ogg.OggPacketInputStream;
import com.sedmelluq.discord.lavaplayer.container.ogg.OggStreamSizeInfo;
import com.sedmelluq.discord.lavaplayer.container.ogg.OggTrackLoader;
import com.sedmelluq.discord.lavaplayer.container.ogg.OggTrackProvider;
import com.sedmelluq.discord.lavaplayer.tools.io.SeekableInputStream;
import com.sedmelluq.discord.lavaplayer.track.AudioReference;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import com.sedmelluq.discord.lavaplayer.track.info.AudioTrackInfoBuilder;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OggContainerProbe
implements MediaContainerProbe {
    private static final Logger log = LoggerFactory.getLogger(OggContainerProbe.class);

    @Override
    public String getName() {
        return "ogg";
    }

    @Override
    public boolean matchesHints(MediaContainerHints hints) {
        return false;
    }

    @Override
    public MediaContainerDetectionResult probe(AudioReference reference, SeekableInputStream stream) throws IOException {
        if (!MediaContainerDetection.checkNextBytes(stream, OggPacketInputStream.OGG_PAGE_HEADER)) {
            return null;
        }
        log.debug("Track {} is an OGG stream.", (Object)reference.identifier);
        AudioTrackInfoBuilder infoBuilder = AudioTrackInfoBuilder.create(reference, stream).setIsStream(true);
        try {
            this.collectStreamInformation(stream, infoBuilder);
        }
        catch (Exception e) {
            log.warn("Failed to collect additional information on OGG stream.", e);
        }
        return new MediaContainerDetectionResult((MediaContainerProbe)this, infoBuilder.build());
    }

    @Override
    public AudioTrack createTrack(AudioTrackInfo trackInfo, SeekableInputStream inputStream) {
        return new OggAudioTrack(trackInfo, inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectStreamInformation(SeekableInputStream stream, AudioTrackInfoBuilder infoBuilder) throws IOException {
        OggPacketInputStream packetInputStream = new OggPacketInputStream(stream);
        OggTrackProvider track = OggTrackLoader.loadTrack(packetInputStream);
        if (track != null) {
            try {
                infoBuilder.apply(track.getMetadata());
                OggStreamSizeInfo sizeInfo = track.seekForSizeInfo();
                if (sizeInfo != null) {
                    infoBuilder.setLength(sizeInfo.totalSamples * 1000L / (long)sizeInfo.sampleRate);
                }
            }
            finally {
                track.close();
            }
        }
    }
}

