/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.container.matroska.format;

import com.sedmelluq.discord.lavaplayer.container.matroska.format.MatroskaBlock;
import com.sedmelluq.discord.lavaplayer.container.matroska.format.MatroskaEbmlReader;
import com.sedmelluq.discord.lavaplayer.container.matroska.format.MatroskaElement;
import com.sedmelluq.discord.lavaplayer.container.matroska.format.MatroskaFileReader;
import java.io.DataInput;
import java.io.IOException;
import java.nio.ByteBuffer;

public class MutableMatroskaBlock
implements MatroskaBlock {
    private int timecode;
    private int trackNumber;
    private boolean keyFrame;
    private int[] frameSizes;
    private int frameCount;
    private ByteBuffer buffer;
    private byte[] bufferArray;

    @Override
    public int getTimecode() {
        return this.timecode;
    }

    @Override
    public int getTrackNumber() {
        return this.trackNumber;
    }

    @Override
    public boolean isKeyFrame() {
        return this.keyFrame;
    }

    @Override
    public int getFrameCount() {
        return this.frameCount;
    }

    @Override
    public ByteBuffer getNextFrameBuffer(MatroskaFileReader reader, int index) throws IOException {
        if (index >= this.frameCount) {
            throw new IllegalArgumentException("Frame index out of bounds.");
        }
        int frameSize = this.frameSizes[index];
        if (this.buffer == null || frameSize > this.buffer.capacity()) {
            this.buffer = ByteBuffer.allocate(this.frameSizes[index] * 2);
            this.bufferArray = this.buffer.array();
        }
        reader.getDataInput().readFully(this.bufferArray, 0, frameSize);
        this.buffer.position(0);
        this.buffer.limit(frameSize);
        return this.buffer;
    }

    public boolean parseHeader(MatroskaFileReader reader, MatroskaElement element, int trackFilter) throws IOException {
        DataInput input = reader.getDataInput();
        this.trackNumber = (int)MatroskaEbmlReader.readEbmlInteger(input, null);
        if (trackFilter >= 0 && this.trackNumber != trackFilter) {
            return false;
        }
        this.timecode = input.readShort();
        int flags = input.readByte() & 0xFF;
        this.keyFrame = (flags & 0x80) != 0;
        int laceType = (flags & 6) >> 1;
        if (laceType != 0) {
            this.setFrameCount((input.readByte() & 0xFF) + 1);
            this.parseLacing(reader, element, laceType);
        } else {
            this.setFrameCount(1);
            this.frameSizes[0] = (int)element.getRemaining(reader.getPosition());
        }
        return true;
    }

    private void parseLacing(MatroskaFileReader reader, MatroskaElement element, int laceType) throws IOException {
        this.setFrameCount(this.frameCount);
        switch (laceType) {
            case 1: {
                this.parseXiphLaceSizes(reader, element);
                break;
            }
            case 2: {
                this.parseFixedLaceSizes(reader, element);
                break;
            }
            default: {
                this.parseEbmlLaceSizes(reader, element);
            }
        }
    }

    private void setFrameCount(int frameCount) {
        if (this.frameSizes == null || this.frameSizes.length < frameCount) {
            this.frameSizes = new int[frameCount * 2];
        }
        this.frameCount = frameCount;
    }

    private void parseXiphLaceSizes(MatroskaFileReader reader, MatroskaElement element) throws IOException {
        int sizeTotal = 0;
        DataInput input = reader.getDataInput();
        for (int i = 0; i < this.frameCount - 1; ++i) {
            int value;
            do {
                value = input.readByte() & 0xFF;
                int n = i;
                this.frameSizes[n] = this.frameSizes[n] + value;
            } while (value == 255);
            sizeTotal += this.frameSizes[i];
        }
        this.frameSizes[this.frameCount - 1] = (int)element.getRemaining(reader.getPosition()) - sizeTotal;
    }

    private void parseFixedLaceSizes(MatroskaFileReader reader, MatroskaElement element) {
        int size = (int)element.getRemaining(reader.getPosition()) / this.frameCount;
        for (int i = 0; i < this.frameCount; ++i) {
            this.frameSizes[i] = size;
        }
    }

    private void parseEbmlLaceSizes(MatroskaFileReader reader, MatroskaElement element) throws IOException {
        DataInput input = reader.getDataInput();
        this.frameSizes[0] = (int)MatroskaEbmlReader.readEbmlInteger(input, null);
        int sizeTotal = this.frameSizes[0];
        for (int i = 1; i < this.frameCount - 1; ++i) {
            this.frameSizes[i] = this.frameSizes[i - 1] + (int)MatroskaEbmlReader.readEbmlInteger(input, MatroskaEbmlReader.Type.LACE_SIGNED);
            sizeTotal += this.frameSizes[i];
        }
        this.frameSizes[this.frameCount - 1] = (int)element.getRemaining(reader.getPosition()) - sizeTotal;
    }
}

