/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.managers;

import javax.annotation.CheckReturnValue;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.Permission;
import net.dv8tion.jda.core.entities.Channel;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.entities.Icon;
import net.dv8tion.jda.core.entities.Member;
import net.dv8tion.jda.core.entities.TextChannel;
import net.dv8tion.jda.core.entities.Webhook;
import net.dv8tion.jda.core.exceptions.InsufficientPermissionException;
import net.dv8tion.jda.core.managers.fields.WebhookField;
import net.dv8tion.jda.core.requests.Request;
import net.dv8tion.jda.core.requests.Response;
import net.dv8tion.jda.core.requests.Route;
import net.dv8tion.jda.core.requests.restaction.AuditableRestAction;
import net.dv8tion.jda.core.utils.Checks;
import org.json.JSONObject;

@Deprecated
public class WebhookManagerUpdatable {
    protected final Webhook webhook;
    protected WebhookField<String> name;
    protected WebhookField<Icon> avatar;
    protected WebhookField<TextChannel> channel;

    public WebhookManagerUpdatable(Webhook webhook) {
        this.webhook = webhook;
        this.setupFields();
    }

    public JDA getJDA() {
        return this.webhook.getJDA();
    }

    public Guild getGuild() {
        return this.webhook.getGuild();
    }

    public TextChannel getChannel() {
        return this.webhook.getChannel();
    }

    public Webhook getWebhook() {
        return this.webhook;
    }

    public WebhookField<String> getNameField() {
        return this.name;
    }

    public WebhookField<Icon> getAvatarField() {
        return this.avatar;
    }

    public WebhookField<TextChannel> getChannelField() {
        return this.channel;
    }

    public void reset() {
        this.name.reset();
        this.avatar.reset();
        this.channel.reset();
    }

    @CheckReturnValue
    public AuditableRestAction<Void> update() {
        Member self = this.getGuild().getSelfMember();
        if (!self.hasPermission((Channel)this.webhook.getChannel(), Permission.MANAGE_WEBHOOKS)) {
            throw new InsufficientPermissionException(Permission.MANAGE_WEBHOOKS);
        }
        if (this.channel.isSet() && !self.hasPermission((Channel)this.channel.getValue(), Permission.MANAGE_WEBHOOKS)) {
            throw new InsufficientPermissionException(Permission.MANAGE_WEBHOOKS, "Permission not available in selected new channel");
        }
        if (!this.shouldUpdate()) {
            return new AuditableRestAction.EmptyRestAction<Object>(this.getJDA(), null);
        }
        JSONObject data = new JSONObject();
        data.put("name", this.name.getOriginalValue());
        if (this.channel.shouldUpdate()) {
            data.put("channel_id", ((TextChannel)this.channel.getValue()).getId());
        }
        if (this.name.shouldUpdate()) {
            data.put("name", this.name.getValue());
        }
        if (this.avatar.shouldUpdate()) {
            Icon value = (Icon)this.avatar.getValue();
            data.put("avatar", value != null ? value.getEncoding() : JSONObject.NULL);
        }
        Route.CompiledRoute route = Route.Webhooks.MODIFY_WEBHOOK.compile(this.webhook.getId());
        return new AuditableRestAction<Void>(this.getJDA(), route, data){

            @Override
            protected void handleResponse(Response response, Request<Void> request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    protected boolean shouldUpdate() {
        return this.name.shouldUpdate() || this.avatar.shouldUpdate() || this.channel.shouldUpdate();
    }

    protected void setupFields() {
        this.name = new WebhookField<String>(this, this.webhook::getName){

            @Override
            public void checkValue(String value) {
                Checks.notNull(value, "default name");
            }
        };
        this.avatar = new WebhookField<Icon>(this, null){

            @Override
            public void checkValue(Icon value) {
            }

            @Override
            public Icon getOriginalValue() {
                throw new UnsupportedOperationException("Cannot easily provide the original Avatar. Use User#getIconUrl() and download it yourself.");
            }

            @Override
            public boolean shouldUpdate() {
                return this.isSet();
            }
        };
        this.channel = new WebhookField<TextChannel>(this, this.webhook::getChannel){

            @Override
            public void checkValue(TextChannel value) {
                Checks.notNull(value, "channel");
                Checks.check(value.getGuild().equals(WebhookManagerUpdatable.this.getGuild()), "Channel is not from the same Guild!");
            }
        };
    }
}

