/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.managers;

import javax.annotation.CheckReturnValue;
import net.dv8tion.jda.core.Permission;
import net.dv8tion.jda.core.entities.Channel;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.entities.Icon;
import net.dv8tion.jda.core.entities.TextChannel;
import net.dv8tion.jda.core.entities.Webhook;
import net.dv8tion.jda.core.exceptions.InsufficientPermissionException;
import net.dv8tion.jda.core.managers.impl.ManagerBase;
import net.dv8tion.jda.core.requests.Route;
import net.dv8tion.jda.core.utils.Checks;
import okhttp3.RequestBody;
import org.json.JSONObject;

public class WebhookManager
extends ManagerBase {
    public static final long NAME = 1L;
    public static final long CHANNEL = 2L;
    public static final long AVATAR = 4L;
    protected final Webhook webhook;
    protected String name;
    protected String channel;
    protected Icon avatar;

    public WebhookManager(Webhook webhook) {
        super(webhook.getJDA(), Route.Webhooks.MODIFY_TOKEN_WEBHOOK.compile(webhook.getId(), webhook.getToken()));
        this.webhook = webhook;
        if (WebhookManager.isPermissionChecksEnabled()) {
            this.checkPermissions();
        }
    }

    public Guild getGuild() {
        return this.webhook.getGuild();
    }

    public TextChannel getChannel() {
        return this.webhook.getChannel();
    }

    public Webhook getWebhook() {
        return this.webhook;
    }

    @Override
    @CheckReturnValue
    public WebhookManager reset(long fields) {
        super.reset(fields);
        if ((fields & 1L) == 1L) {
            this.name = null;
        }
        if ((fields & 2L) == 2L) {
            this.channel = null;
        }
        if ((fields & 4L) == 4L) {
            this.avatar = null;
        }
        return this;
    }

    @Override
    @CheckReturnValue
    public WebhookManager reset(long ... fields) {
        super.reset(fields);
        return this;
    }

    @Override
    @CheckReturnValue
    public WebhookManager reset() {
        super.reset();
        this.name = null;
        this.channel = null;
        this.avatar = null;
        return this;
    }

    @CheckReturnValue
    public WebhookManager setName(String name) {
        Checks.notBlank(name, "Name");
        this.name = name;
        this.set |= 1L;
        return this;
    }

    @CheckReturnValue
    public WebhookManager setAvatar(Icon icon) {
        this.avatar = icon;
        this.set |= 4L;
        return this;
    }

    @CheckReturnValue
    public WebhookManager setChannel(TextChannel channel) {
        Checks.notNull(channel, "Channel");
        Checks.check(channel.getGuild().equals(this.getGuild()), "Channel is not from the same guild");
        this.channel = channel.getId();
        this.set |= 2L;
        return this;
    }

    @Override
    protected RequestBody finalizeData() {
        JSONObject data = new JSONObject();
        if (this.shouldUpdate(1L)) {
            data.put("name", this.name);
        }
        if (this.shouldUpdate(2L)) {
            data.put("channel_id", this.channel);
        }
        if (this.shouldUpdate(4L)) {
            data.put("avatar", this.avatar == null ? JSONObject.NULL : this.avatar.getEncoding());
        }
        return this.getRequestBody(data);
    }

    @Override
    protected boolean checkPermissions() {
        if (!this.getGuild().getSelfMember().hasPermission((Channel)this.getChannel(), Permission.MANAGE_WEBHOOKS)) {
            throw new InsufficientPermissionException(Permission.MANAGE_WEBHOOKS);
        }
        return super.checkPermissions();
    }
}

