/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.entities.impl;

import gnu.trove.map.TLongObjectMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.dv8tion.jda.core.entities.Category;
import net.dv8tion.jda.core.entities.ChannelType;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.entities.IPermissionHolder;
import net.dv8tion.jda.core.entities.Member;
import net.dv8tion.jda.core.entities.PermissionOverride;
import net.dv8tion.jda.core.entities.VoiceChannel;
import net.dv8tion.jda.core.entities.impl.AbstractChannelImpl;
import net.dv8tion.jda.core.entities.impl.GuildImpl;
import net.dv8tion.jda.core.requests.restaction.ChannelAction;
import net.dv8tion.jda.core.utils.Checks;
import net.dv8tion.jda.core.utils.MiscUtil;

public class VoiceChannelImpl
extends AbstractChannelImpl<VoiceChannelImpl>
implements VoiceChannel {
    private final TLongObjectMap<Member> connectedMembers = MiscUtil.newLongMap();
    private int userLimit;
    private int bitrate;

    public VoiceChannelImpl(long id, GuildImpl guild) {
        super(id, guild);
    }

    @Override
    public int getUserLimit() {
        return this.userLimit;
    }

    @Override
    public int getBitrate() {
        return this.bitrate;
    }

    @Override
    public ChannelType getType() {
        return ChannelType.VOICE;
    }

    @Override
    public List<Member> getMembers() {
        return Collections.unmodifiableList(new ArrayList<Member>(this.connectedMembers.valueCollection()));
    }

    @Override
    public int getPosition() {
        List<VoiceChannel> channels = this.getGuild().getVoiceChannels();
        for (int i = 0; i < channels.size(); ++i) {
            if (channels.get(i) != this) continue;
            return i;
        }
        throw new AssertionError((Object)"Somehow when determining position we never found the VoiceChannel in the Guild's channels? wtf?");
    }

    @Override
    public ChannelAction createCopy(Guild guild) {
        Checks.notNull(guild, "Guild");
        ChannelAction action = guild.getController().createVoiceChannel(this.name).setBitrate(this.bitrate).setUserlimit(this.userLimit);
        if (guild.equals(this.getGuild())) {
            Category parent = this.getParent();
            if (parent != null) {
                action.setParent(parent);
            }
            for (PermissionOverride o : this.overrides.valueCollection()) {
                if (o.isMemberOverride()) {
                    action.addPermissionOverride((IPermissionHolder)o.getMember(), o.getAllowedRaw(), o.getDeniedRaw());
                    continue;
                }
                action.addPermissionOverride((IPermissionHolder)o.getRole(), o.getAllowedRaw(), o.getDeniedRaw());
            }
        }
        return action;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof VoiceChannel)) {
            return false;
        }
        VoiceChannel oVChannel = (VoiceChannel)o;
        return this == oVChannel || this.getIdLong() == oVChannel.getIdLong();
    }

    public String toString() {
        return "VC:" + this.getName() + '(' + this.id + ')';
    }

    @Override
    public int compareTo(VoiceChannel chan) {
        Checks.notNull(chan, "Other VoiceChannel");
        if (this == chan) {
            return 0;
        }
        Checks.check(this.getGuild().equals(chan.getGuild()), "Cannot compare VoiceChannels that aren't from the same guild!");
        if (this.getPositionRaw() == chan.getPositionRaw()) {
            return Long.compare(this.id, chan.getIdLong());
        }
        return Integer.compare(this.rawPosition, chan.getPositionRaw());
    }

    public VoiceChannelImpl setUserLimit(int userLimit) {
        this.userLimit = userLimit;
        return this;
    }

    public VoiceChannelImpl setBitrate(int bitrate) {
        this.bitrate = bitrate;
        return this;
    }

    public TLongObjectMap<Member> getConnectedMembersMap() {
        return this.connectedMembers;
    }
}

