/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.entities.impl;

import java.util.concurrent.locks.ReentrantLock;
import net.dv8tion.jda.core.AccountType;
import net.dv8tion.jda.core.entities.PrivateChannel;
import net.dv8tion.jda.core.entities.SelfUser;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.entities.impl.UserImpl;
import net.dv8tion.jda.core.exceptions.AccountTypeException;
import net.dv8tion.jda.core.managers.AccountManager;
import net.dv8tion.jda.core.managers.AccountManagerUpdatable;
import net.dv8tion.jda.core.requests.RestAction;
import net.dv8tion.jda.core.utils.MiscUtil;

public class SelfUserImpl
extends UserImpl
implements SelfUser {
    protected final ReentrantLock mngLock = new ReentrantLock();
    protected volatile AccountManager manager;
    @Deprecated
    protected volatile AccountManagerUpdatable managerUpdatable;
    private boolean verified;
    private boolean mfaEnabled;
    private String email;
    private String phoneNumber;
    private boolean mobile;
    private boolean nitro;

    public SelfUserImpl(long id, JDAImpl api) {
        super(id, api);
    }

    @Override
    public boolean hasPrivateChannel() {
        return false;
    }

    @Override
    public PrivateChannel getPrivateChannel() {
        throw new UnsupportedOperationException("You cannot get a PrivateChannel with yourself (SelfUser)");
    }

    @Override
    public RestAction<PrivateChannel> openPrivateChannel() {
        throw new UnsupportedOperationException("You cannot open a PrivateChannel with yourself (SelfUser)");
    }

    @Override
    public boolean isVerified() {
        return this.verified;
    }

    @Override
    public boolean isMfaEnabled() {
        return this.mfaEnabled;
    }

    @Override
    public String getEmail() throws AccountTypeException {
        if (this.api.getAccountType() != AccountType.CLIENT) {
            throw new AccountTypeException(AccountType.CLIENT, "Email retrieval can only be done on CLIENT accounts!");
        }
        return this.email;
    }

    @Override
    public String getPhoneNumber() throws AccountTypeException {
        if (this.api.getAccountType() != AccountType.CLIENT) {
            throw new AccountTypeException(AccountType.CLIENT, "Phone number retrieval can only be done on CLIENT accounts!");
        }
        return this.phoneNumber;
    }

    @Override
    public boolean isMobile() throws AccountTypeException {
        if (this.api.getAccountType() != AccountType.CLIENT) {
            throw new AccountTypeException(AccountType.CLIENT, "Mobile app retrieval can only be done on CLIENT accounts!");
        }
        return this.mobile;
    }

    @Override
    public boolean isNitro() throws AccountTypeException {
        if (this.api.getAccountType() != AccountType.CLIENT) {
            throw new AccountTypeException(AccountType.CLIENT, "Nitro status retrieval can only be done on CLIENT accounts!");
        }
        return this.nitro;
    }

    @Override
    public long getAllowedFileSize() {
        if (this.nitro) {
            return 0x3200000L;
        }
        return 0x800000L;
    }

    @Override
    public AccountManager getManager() {
        AccountManager mng = this.manager;
        if (mng == null) {
            mng = MiscUtil.locked(this.mngLock, () -> {
                if (this.manager == null) {
                    this.manager = new AccountManager(this);
                }
                return this.manager;
            });
        }
        return mng;
    }

    @Override
    @Deprecated
    public AccountManagerUpdatable getManagerUpdatable() {
        AccountManagerUpdatable mng = this.managerUpdatable;
        if (mng == null) {
            mng = MiscUtil.locked(this.mngLock, () -> {
                if (this.managerUpdatable == null) {
                    this.managerUpdatable = new AccountManagerUpdatable(this);
                }
                return this.managerUpdatable;
            });
        }
        return mng;
    }

    public SelfUserImpl setVerified(boolean verified) {
        this.verified = verified;
        return this;
    }

    public SelfUserImpl setMfaEnabled(boolean enabled) {
        this.mfaEnabled = enabled;
        return this;
    }

    public SelfUserImpl setEmail(String email) {
        this.email = email;
        return this;
    }

    public SelfUserImpl setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    public SelfUserImpl setMobile(boolean mobile) {
        this.mobile = mobile;
        return this;
    }

    public SelfUserImpl setNitro(boolean nitro) {
        this.nitro = nitro;
        return this;
    }
}

