/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.entities.impl;

import gnu.trove.set.TLongSet;
import gnu.trove.set.hash.TLongHashSet;
import java.time.OffsetDateTime;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Formatter;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.dv8tion.jda.client.entities.Group;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.MessageBuilder;
import net.dv8tion.jda.core.Permission;
import net.dv8tion.jda.core.entities.Category;
import net.dv8tion.jda.core.entities.Channel;
import net.dv8tion.jda.core.entities.ChannelType;
import net.dv8tion.jda.core.entities.Emote;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.entities.IFakeable;
import net.dv8tion.jda.core.entities.IMentionable;
import net.dv8tion.jda.core.entities.ISnowflake;
import net.dv8tion.jda.core.entities.Member;
import net.dv8tion.jda.core.entities.Message;
import net.dv8tion.jda.core.entities.MessageChannel;
import net.dv8tion.jda.core.entities.MessageEmbed;
import net.dv8tion.jda.core.entities.MessageReaction;
import net.dv8tion.jda.core.entities.MessageType;
import net.dv8tion.jda.core.entities.PrivateChannel;
import net.dv8tion.jda.core.entities.Role;
import net.dv8tion.jda.core.entities.TextChannel;
import net.dv8tion.jda.core.entities.User;
import net.dv8tion.jda.core.entities.impl.AbstractMessage;
import net.dv8tion.jda.core.entities.impl.EmoteImpl;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.exceptions.InsufficientPermissionException;
import net.dv8tion.jda.core.requests.RestAction;
import net.dv8tion.jda.core.requests.restaction.AuditableRestAction;
import net.dv8tion.jda.core.requests.restaction.MessageAction;
import net.dv8tion.jda.core.utils.Checks;
import net.dv8tion.jda.core.utils.MiscUtil;
import org.apache.commons.collections4.CollectionUtils;

public class ReceivedMessage
extends AbstractMessage {
    private final Object mutex = new Object();
    protected final JDAImpl api;
    protected final long id;
    protected final MessageType type;
    protected final MessageChannel channel;
    protected final boolean fromWebhook;
    protected final boolean mentionsEveryone;
    protected final boolean pinned;
    protected final User author;
    protected final OffsetDateTime editedTime;
    protected final List<MessageReaction> reactions;
    protected final List<Message.Attachment> attachments;
    protected final List<MessageEmbed> embeds;
    protected final TLongSet mentionedUsers;
    protected final TLongSet mentionedRoles;
    protected String altContent = null;
    protected String strippedContent = null;
    protected List<User> userMentions = null;
    protected List<Emote> emoteMentions = null;
    protected List<Role> roleMentions = null;
    protected List<TextChannel> channelMentions = null;
    protected List<String> invites = null;

    public ReceivedMessage(long id, MessageChannel channel, MessageType type, boolean fromWebhook, boolean mentionsEveryone, TLongSet mentionedUsers, TLongSet mentionedRoles, boolean tts, boolean pinned, String content, String nonce, User author, OffsetDateTime editTime, List<MessageReaction> reactions, List<Message.Attachment> attachments, List<MessageEmbed> embeds) {
        super(content, nonce, tts);
        this.id = id;
        this.channel = channel;
        this.type = type;
        this.api = channel != null ? (JDAImpl)channel.getJDA() : null;
        this.fromWebhook = fromWebhook;
        this.mentionsEveryone = mentionsEveryone;
        this.pinned = pinned;
        this.author = author;
        this.editedTime = editTime;
        this.reactions = Collections.unmodifiableList(reactions);
        this.attachments = Collections.unmodifiableList(attachments);
        this.embeds = Collections.unmodifiableList(embeds);
        this.mentionedUsers = mentionedUsers;
        this.mentionedRoles = mentionedRoles;
    }

    @Override
    public JDA getJDA() {
        return this.api;
    }

    @Override
    public boolean isPinned() {
        return this.pinned;
    }

    @Override
    public RestAction<Void> pin() {
        return this.channel.pinMessageById(this.getIdLong());
    }

    @Override
    public RestAction<Void> unpin() {
        return this.channel.unpinMessageById(this.getIdLong());
    }

    @Override
    public RestAction<Void> addReaction(Emote emote) {
        Checks.notNull(emote, "Emote");
        MessageReaction reaction = this.reactions.parallelStream().filter(r -> Objects.equals(r.getReactionEmote().getId(), emote.getId())).findFirst().orElse(null);
        if (reaction == null) {
            this.checkFake(emote, "Emote");
            if (!emote.canInteract(this.getJDA().getSelfUser(), this.channel)) {
                throw new IllegalArgumentException("Cannot react with the provided emote because it is not available in the current channel.");
            }
        } else if (reaction.isSelf()) {
            return new RestAction.EmptyRestAction<Object>(this.getJDA(), null);
        }
        return this.channel.addReactionById(this.getIdLong(), emote);
    }

    @Override
    public RestAction<Void> addReaction(String unicode) {
        Checks.notEmpty(unicode, "Provided Unicode");
        MessageReaction reaction = this.reactions.parallelStream().filter(r -> Objects.equals(r.getReactionEmote().getName(), unicode)).findFirst().orElse(null);
        if (reaction != null && reaction.isSelf()) {
            return new RestAction.EmptyRestAction<Object>(this.getJDA(), null);
        }
        return this.channel.addReactionById(this.getIdLong(), unicode);
    }

    @Override
    public RestAction<Void> clearReactions() {
        if (!this.isFromType(ChannelType.TEXT)) {
            throw new IllegalStateException("Cannot clear reactions from a message in a Group or PrivateChannel.");
        }
        return this.getTextChannel().clearReactionsById(this.getId());
    }

    @Override
    public MessageType getType() {
        return this.type;
    }

    @Override
    public long getIdLong() {
        return this.id;
    }

    @Override
    public synchronized List<User> getMentionedUsers() {
        if (this.userMentions == null) {
            this.userMentions = new ArrayList<User>();
            Matcher matcher = Message.MentionType.USER.getPattern().matcher(this.content);
            while (matcher.find()) {
                try {
                    long id = MiscUtil.parseSnowflake(matcher.group(1));
                    if (!this.mentionedUsers.contains(id)) continue;
                    User user = this.getJDA().getUserById(id);
                    if (user == null) {
                        user = this.api.getFakeUserMap().get(id);
                    }
                    if (user == null || this.userMentions.contains(user)) continue;
                    this.userMentions.add(user);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            this.userMentions = Collections.unmodifiableList(this.userMentions);
        }
        return this.userMentions;
    }

    @Override
    public synchronized List<TextChannel> getMentionedChannels() {
        if (this.channelMentions == null) {
            this.channelMentions = new ArrayList<TextChannel>();
            Matcher matcher = Message.MentionType.CHANNEL.getPattern().matcher(this.content);
            while (matcher.find()) {
                try {
                    String id = matcher.group(1);
                    TextChannel channel = this.getJDA().getTextChannelById(id);
                    if (channel == null || this.channelMentions.contains(channel)) continue;
                    this.channelMentions.add(channel);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            this.channelMentions = Collections.unmodifiableList(this.channelMentions);
        }
        return this.channelMentions;
    }

    @Override
    public synchronized List<Role> getMentionedRoles() {
        if (this.roleMentions == null) {
            this.roleMentions = new ArrayList<Role>();
            Matcher matcher = Message.MentionType.ROLE.getPattern().matcher(this.content);
            while (matcher.find()) {
                try {
                    long id = MiscUtil.parseSnowflake(matcher.group(1));
                    if (!this.mentionedRoles.contains(id)) continue;
                    Role role = null;
                    if (this.isFromType(ChannelType.TEXT)) {
                        role = this.getGuild().getRoleById(id);
                    }
                    if (role == null) {
                        role = this.getJDA().getRoleById(id);
                    }
                    if (role == null || this.roleMentions.contains(role)) continue;
                    this.roleMentions.add(role);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            this.roleMentions = Collections.unmodifiableList(this.roleMentions);
        }
        return this.roleMentions;
    }

    @Override
    public List<Member> getMentionedMembers(Guild guild) {
        Checks.notNull(guild, "Guild");
        List<User> mentionedUsers = this.getMentionedUsers();
        ArrayList<Member> members = new ArrayList<Member>();
        for (User user : mentionedUsers) {
            Member member = guild.getMember(user);
            if (member == null) continue;
            members.add(member);
        }
        return Collections.unmodifiableList(members);
    }

    @Override
    public List<Member> getMentionedMembers() {
        if (this.isFromType(ChannelType.TEXT)) {
            return this.getMentionedMembers(this.getGuild());
        }
        throw new IllegalStateException("You must specify a Guild for Messages which are not sent from a TextChannel!");
    }

    @Override
    public List<IMentionable> getMentions(Message.MentionType ... types) {
        if (types == null || types.length == 0) {
            return this.getMentions(Message.MentionType.values());
        }
        ArrayList<ISnowflake> mentions = new ArrayList<ISnowflake>();
        boolean channel = false;
        boolean role = false;
        boolean user = false;
        boolean emote = false;
        block6: for (Message.MentionType type : types) {
            switch (type) {
                default: {
                    continue block6;
                }
                case CHANNEL: {
                    if (!channel) {
                        mentions.addAll(this.getMentionedChannels());
                    }
                    channel = true;
                    continue block6;
                }
                case USER: {
                    if (!user) {
                        mentions.addAll(this.getMentionedUsers());
                    }
                    user = true;
                    continue block6;
                }
                case ROLE: {
                    if (!role) {
                        mentions.addAll(this.getMentionedRoles());
                    }
                    role = true;
                    continue block6;
                }
                case EMOTE: {
                    if (!emote) {
                        mentions.addAll(this.getEmotes());
                    }
                    emote = true;
                }
            }
        }
        return Collections.unmodifiableList(mentions);
    }

    @Override
    public boolean isMentioned(IMentionable mentionable, Message.MentionType ... types) {
        Checks.notNull(types, "Mention Types");
        if (types.length == 0) {
            return this.isMentioned(mentionable, Message.MentionType.values());
        }
        boolean isUserEntity = mentionable instanceof User || mentionable instanceof Member;
        block8: for (Message.MentionType type : types) {
            switch (type) {
                case HERE: {
                    if (!this.isMass("@here") || !isUserEntity) continue block8;
                    return true;
                }
                case EVERYONE: {
                    if (!this.isMass("@everyone") || !isUserEntity) continue block8;
                    return true;
                }
                case USER: {
                    if (!this.isUserMentioned(mentionable)) continue block8;
                    return true;
                }
                case ROLE: {
                    if (!this.isRoleMentioned(mentionable)) continue block8;
                    return true;
                }
                case CHANNEL: {
                    if (!(mentionable instanceof TextChannel) || !this.getMentionedChannels().contains(mentionable)) continue block8;
                    return true;
                }
                case EMOTE: {
                    if (!(mentionable instanceof Emote) || !this.getEmotes().contains(mentionable)) continue block8;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isUserMentioned(IMentionable mentionable) {
        if (mentionable instanceof User) {
            return this.getMentionedUsers().contains(mentionable);
        }
        if (mentionable instanceof Member) {
            Member member = (Member)mentionable;
            return this.getMentionedUsers().contains(member.getUser());
        }
        return false;
    }

    private boolean isRoleMentioned(IMentionable mentionable) {
        if (mentionable instanceof Role) {
            return this.getMentionedRoles().contains(mentionable);
        }
        if (mentionable instanceof Member) {
            Member member = (Member)mentionable;
            return CollectionUtils.containsAny(this.getMentionedRoles(), member.getRoles());
        }
        if (this.isFromType(ChannelType.TEXT) && mentionable instanceof User) {
            Member member = this.getGuild().getMember((User)mentionable);
            return member != null && CollectionUtils.containsAny(this.getMentionedRoles(), member.getRoles());
        }
        return false;
    }

    private boolean isMass(String s) {
        return this.mentionsEveryone && this.content.contains(s);
    }

    @Override
    public boolean mentionsEveryone() {
        return this.mentionsEveryone;
    }

    @Override
    public boolean isEdited() {
        return this.editedTime != null;
    }

    @Override
    public OffsetDateTime getEditedTime() {
        return this.editedTime;
    }

    @Override
    public User getAuthor() {
        return this.author;
    }

    @Override
    public Member getMember() {
        return this.isFromType(ChannelType.TEXT) ? this.getGuild().getMember(this.getAuthor()) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getContentStripped() {
        if (this.strippedContent != null) {
            return this.strippedContent;
        }
        Object object = this.mutex;
        synchronized (object) {
            if (this.strippedContent != null) {
                return this.strippedContent;
            }
            String tmp = this.getContentDisplay();
            String[] keys = new String[]{"*", "_", "`", "~~"};
            TreeSet<FormatToken> tokens = new TreeSet<FormatToken>(Comparator.comparingInt(t -> t.start));
            for (String key : keys) {
                Matcher matcher = Pattern.compile(Pattern.quote(key)).matcher(tmp);
                while (matcher.find()) {
                    tokens.add(new FormatToken(key, matcher.start()));
                }
            }
            ArrayDeque<FormatToken> stack = new ArrayDeque<FormatToken>();
            ArrayList<FormatToken> toRemove = new ArrayList<FormatToken>();
            boolean inBlock = false;
            for (FormatToken token : tokens) {
                if (stack.isEmpty() || !((FormatToken)stack.peek()).format.equals(token.format) || ((FormatToken)stack.peek()).start + token.format.length() == token.start) {
                    if (!inBlock) {
                        if (token.format.equals("`")) {
                            stack.clear();
                            inBlock = true;
                        }
                        stack.push(token);
                        continue;
                    }
                    if (!token.format.equals("`")) continue;
                    stack.push(token);
                    continue;
                }
                if (stack.isEmpty()) continue;
                toRemove.add((FormatToken)stack.pop());
                toRemove.add(token);
                if (!token.format.equals("`") || !stack.isEmpty()) continue;
                inBlock = false;
            }
            toRemove.sort(Comparator.comparingInt(t -> t.start));
            StringBuilder out = new StringBuilder();
            int currIndex = 0;
            for (FormatToken formatToken : toRemove) {
                if (currIndex < formatToken.start) {
                    out.append(tmp.substring(currIndex, formatToken.start));
                }
                currIndex = formatToken.start + formatToken.format.length();
            }
            if (currIndex < tmp.length()) {
                out.append(tmp.substring(currIndex));
            }
            this.strippedContent = out.toString().replace("*", "\\*").replace("_", "\\_").replace("~", "\\~");
            return this.strippedContent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getContentDisplay() {
        if (this.altContent != null) {
            return this.altContent;
        }
        Object object = this.mutex;
        synchronized (object) {
            if (this.altContent != null) {
                return this.altContent;
            }
            String tmp = this.content;
            for (User user : this.getMentionedUsers()) {
                String name = this.isFromType(ChannelType.TEXT) && this.getGuild().isMember(user) ? this.getGuild().getMember(user).getEffectiveName() : user.getName();
                tmp = tmp.replaceAll("<@!?" + Pattern.quote(user.getId()) + '>', '@' + Matcher.quoteReplacement(name));
            }
            for (Emote emote : this.getEmotes()) {
                tmp = tmp.replace(emote.getAsMention(), ":" + emote.getName() + ":");
            }
            for (TextChannel mentionedChannel : this.getMentionedChannels()) {
                tmp = tmp.replace(mentionedChannel.getAsMention(), '#' + mentionedChannel.getName());
            }
            for (Role mentionedRole : this.getMentionedRoles()) {
                tmp = tmp.replace(mentionedRole.getAsMention(), '@' + mentionedRole.getName());
            }
            this.altContent = tmp;
            return this.altContent;
        }
    }

    @Override
    public String getContentRaw() {
        return this.content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getInvites() {
        if (this.invites != null) {
            return this.invites;
        }
        Object object = this.mutex;
        synchronized (object) {
            if (this.invites != null) {
                return this.invites;
            }
            this.invites = new ArrayList<String>();
            Matcher m = INVITE_PATTERN.matcher(this.getContentRaw());
            while (m.find()) {
                this.invites.add(m.group(1));
            }
            this.invites = Collections.unmodifiableList(this.invites);
            return this.invites;
        }
    }

    @Override
    public String getNonce() {
        return this.nonce;
    }

    @Override
    public boolean isFromType(ChannelType type) {
        return this.getChannelType() == type;
    }

    @Override
    public ChannelType getChannelType() {
        return this.channel.getType();
    }

    @Override
    public MessageChannel getChannel() {
        return this.channel;
    }

    @Override
    public PrivateChannel getPrivateChannel() {
        return this.isFromType(ChannelType.PRIVATE) ? (PrivateChannel)this.channel : null;
    }

    @Override
    public Group getGroup() {
        return this.isFromType(ChannelType.GROUP) ? (Group)this.channel : null;
    }

    @Override
    public TextChannel getTextChannel() {
        return this.isFromType(ChannelType.TEXT) ? (TextChannel)this.channel : null;
    }

    @Override
    public Category getCategory() {
        return this.isFromType(ChannelType.TEXT) ? this.getTextChannel().getParent() : null;
    }

    @Override
    public Guild getGuild() {
        return this.isFromType(ChannelType.TEXT) ? this.getTextChannel().getGuild() : null;
    }

    @Override
    public List<Message.Attachment> getAttachments() {
        return this.attachments;
    }

    @Override
    public List<MessageEmbed> getEmbeds() {
        return this.embeds;
    }

    @Override
    public synchronized List<Emote> getEmotes() {
        if (this.emoteMentions == null) {
            TLongHashSet foundIds = new TLongHashSet();
            this.emoteMentions = new ArrayList<Emote>();
            Matcher matcher = Message.MentionType.EMOTE.getPattern().matcher(this.getContentRaw());
            while (matcher.find()) {
                try {
                    long emoteId = MiscUtil.parseSnowflake(matcher.group(2));
                    if (foundIds.contains(emoteId)) continue;
                    foundIds.add(emoteId);
                    String emoteName = matcher.group(1);
                    boolean animated = matcher.group(0).startsWith("<a:");
                    Emote emote = this.getJDA().getEmoteById(emoteId);
                    if (emote == null) {
                        emote = new EmoteImpl(emoteId, this.api).setAnimated(animated).setName(emoteName);
                    }
                    this.emoteMentions.add(emote);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            this.emoteMentions = Collections.unmodifiableList(this.emoteMentions);
        }
        return this.emoteMentions;
    }

    @Override
    public List<MessageReaction> getReactions() {
        return this.reactions;
    }

    @Override
    public boolean isWebhookMessage() {
        return this.fromWebhook;
    }

    @Override
    public boolean isTTS() {
        return this.isTTS;
    }

    @Override
    public MessageAction editMessage(CharSequence newContent) {
        return this.editMessage(new MessageBuilder().append(newContent).build());
    }

    @Override
    public MessageAction editMessage(MessageEmbed newContent) {
        return this.editMessage(new MessageBuilder().setEmbed(newContent).build());
    }

    @Override
    public MessageAction editMessageFormat(String format, Object ... args) {
        Checks.notBlank(format, "Format String");
        return this.editMessage(new MessageBuilder().appendFormat(format, args).build());
    }

    @Override
    public MessageAction editMessage(Message newContent) {
        if (!this.getJDA().getSelfUser().equals(this.getAuthor())) {
            throw new IllegalStateException("Attempted to update message that was not sent by this account. You cannot modify other User's messages!");
        }
        return this.getChannel().editMessageById(this.getIdLong(), newContent);
    }

    @Override
    public AuditableRestAction<Void> delete() {
        if (!this.getJDA().getSelfUser().equals(this.getAuthor())) {
            if (this.isFromType(ChannelType.PRIVATE) || this.isFromType(ChannelType.GROUP)) {
                throw new IllegalStateException("Cannot delete another User's messages in a Group or PrivateChannel.");
            }
            if (!this.getGuild().getSelfMember().hasPermission((Channel)((TextChannel)this.getChannel()), Permission.MESSAGE_MANAGE)) {
                throw new InsufficientPermissionException(Permission.MESSAGE_MANAGE);
            }
        }
        return this.channel.deleteMessageById(this.getIdLong());
    }

    public boolean equals(Object o) {
        if (!(o instanceof ReceivedMessage)) {
            return false;
        }
        ReceivedMessage oMsg = (ReceivedMessage)o;
        return this == oMsg || this.id == oMsg.id;
    }

    public int hashCode() {
        return Long.hashCode(this.id);
    }

    public String toString() {
        return this.author != null ? String.format("M:%#s:%.20s(%s)", this.author, this, this.getId()) : String.format("M:%.20s", this);
    }

    @Override
    protected void unsupported() {
        throw new UnsupportedOperationException("This operation is not supported on received messages!");
    }

    private boolean hasPermission(Permission permission) {
        switch (this.channel.getType()) {
            case TEXT: {
                return this.getMember().hasPermission((Channel)this.getTextChannel(), permission);
            }
        }
        return true;
    }

    private void checkPermission(Permission permission) {
        if (this.channel.getType() == ChannelType.TEXT) {
            Channel location = (Channel)((Object)this.channel);
            if (!location.getGuild().getSelfMember().hasPermission(location, permission)) {
                throw new InsufficientPermissionException(permission);
            }
        }
    }

    private void checkFake(IFakeable o, String name) {
        if (o.isFake()) {
            throw new IllegalArgumentException("We are unable to use a fake " + name + " in this situation!");
        }
    }

    @Override
    public void formatTo(Formatter formatter, int flags, int width, int precision) {
        String out;
        boolean upper = (flags & 2) == 2;
        boolean leftJustified = (flags & 1) == 1;
        boolean alt = (flags & 4) == 4;
        String string = out = alt ? this.getContentRaw() : this.getContentDisplay();
        if (upper) {
            out = out.toUpperCase(formatter.locale());
        }
        this.appendFormat(formatter, width, precision, leftJustified, out);
    }

    private static class FormatToken {
        public final String format;
        public final int start;

        public FormatToken(String format, int start) {
            this.format = format;
            this.start = start;
        }
    }
}

