/*
 * Decompiled with CFR 0.152.
 */
package me.iblitzkriegi.vixio.util.skript;

import ch.njol.skript.classes.Serializer;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.localization.Language;
import ch.njol.util.Validate;
import ch.njol.yggdrasil.Fields;
import java.io.NotSerializableException;
import java.io.StreamCorruptedException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import me.iblitzkriegi.vixio.util.ReflectionUtils;
import me.iblitzkriegi.vixio.util.skript.SimpleType;

public class EnumMapper<E extends Enum<E>> {
    private static final HashMap<String, String> LANG_MAP = (HashMap)ReflectionUtils.getField(Language.class, null, "english");
    private Class<E> clazz;
    private Map<String, E> parseMap = new HashMap<String, E>();
    private String node;

    public static <C extends Enum<C>> SimpleType<C> register(Class<C> clazz, String name, String pattern) {
        Validate.notNull((Object[])new Object[]{clazz, name, pattern});
        return EnumMapper.register(clazz, name, pattern, clazz.getSimpleName().toLowerCase(Locale.ENGLISH));
    }

    public static <C extends Enum<C>> SimpleType<C> register(Class<C> clazz, String name, String pattern, String node) {
        Validate.notNull((Object[])new Object[]{clazz, name, pattern, node});
        final EnumMapper<C> PARSER = new EnumMapper<C>(clazz, node);
        SimpleType type = new SimpleType<C>(clazz, name, pattern){

            @Override
            public C parse(String name, ParseContext context) {
                return PARSER.parse(name);
            }

            @Override
            public String toString(C value, int flags) {
                return PARSER.toString(value, flags);
            }

            @Override
            public boolean canParse(ParseContext pc) {
                return true;
            }
        };
        type.serializer(PARSER.getSerializer());
        return type;
    }

    public EnumMapper(Class<E> clazz) {
        this(clazz, clazz.getSimpleName().toLowerCase(Locale.ENGLISH));
    }

    public EnumMapper(Class<E> clazz, String node) {
        Validate.notNull(clazz, (String)node);
        this.node = node;
        this.clazz = clazz;
        this.map();
    }

    public void map() {
        for (Enum e : (Enum[])this.clazz.getEnumConstants()) {
            String lowercase = e.name().toLowerCase(Locale.ENGLISH);
            String replaced = lowercase.replace("_", " ");
            LANG_MAP.put(this.node + "." + lowercase, replaced);
            this.parseMap.put(replaced, e);
        }
    }

    public E parse(String s) {
        return (E)((Enum)this.parseMap.get(s));
    }

    public String toString(E e, int flags) {
        for (Map.Entry<String, E> entry : this.parseMap.entrySet()) {
            if (entry.getValue() != e) continue;
            return entry.getKey();
        }
        return ((Enum)e).name();
    }

    public String getAllNames() {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (Enum e : (Enum[])this.clazz.getEnumConstants()) {
            if (!first) {
                builder.append(", ");
            }
            builder.append(this.toString(e, 0));
            first = false;
        }
        return builder.toString();
    }

    public Serializer<E> getSerializer() {
        return new Serializer<E>(){

            public Fields serialize(E o) throws NotSerializableException {
                Fields fields = new Fields();
                fields.putObject("name", (Object)((Enum)o).name());
                return fields;
            }

            public void deserialize(E o, Fields f) throws StreamCorruptedException, NotSerializableException {
            }

            protected E deserialize(Fields fields) throws StreamCorruptedException, NotSerializableException {
                try {
                    return Enum.valueOf(EnumMapper.this.clazz, (String)fields.getObject("name"));
                }
                catch (ClassCastException | IllegalArgumentException e) {
                    throw new StreamCorruptedException();
                }
            }

            public boolean mustSyncDeserialization() {
                return false;
            }

            protected boolean canBeInstantiated() {
                return false;
            }
        };
    }
}

