/*
 * Decompiled with CFR 0.152.
 */
package me.iblitzkriegi.vixio.conditions;

import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import me.iblitzkriegi.vixio.Vixio;
import me.iblitzkriegi.vixio.util.skript.SkriptUtil;
import net.dv8tion.jda.core.Permission;
import net.dv8tion.jda.core.entities.Member;
import org.bukkit.event.Event;

public class CondHasPermission
extends Condition {
    private Expression<Member> member;
    private Expression<Permission> permission;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.member = matchedPattern == 1 || matchedPattern == 3 ? SkriptUtil.combineUserAndGuild(exprs[0], exprs[2]) : exprs[0];
        this.permission = exprs[1];
        this.setNegated(matchedPattern > 1);
        return true;
    }

    public boolean check(Event e) {
        Member member = (Member)this.member.getSingle(e);
        Permission permission = (Permission)((Object)this.permission.getSingle(e));
        if (permission == null || member == null) {
            return false;
        }
        return this.isNegated() != member.hasPermission(permission);
    }

    public String toString(Event e, boolean debug) {
        return this.member.toString(e, debug) + " has permission " + this.permission.toString(e, debug);
    }

    static {
        Vixio.getInstance().registerCondition(CondHasPermission.class, "%member% has permission %permission%", "%user% has permission %permission% [in %guild%]", "%member% doesn't have permission %permission%", "%user% doesn't have permission %permission% [in %guild%]").setName("Member Has Permission").setDesc("Check if a member has a permission").setExample("if event-member has permission voice connect");
    }
}

