/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.tools.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class DirectBufferStreamBroker {
    private final byte[] copyBuffer;
    private final int initialSize;
    private ByteBuffer currentBuffer;

    public DirectBufferStreamBroker(int initialSize) {
        this.initialSize = initialSize;
        this.copyBuffer = new byte[512];
        this.currentBuffer = ByteBuffer.allocateDirect(initialSize);
    }

    public void resetAndCompact() {
        this.currentBuffer = ByteBuffer.allocateDirect(this.initialSize);
    }

    public void clear() {
        this.currentBuffer.clear();
    }

    public ByteBuffer getBuffer() {
        ByteBuffer buffer = this.currentBuffer.duplicate();
        buffer.flip();
        return buffer;
    }

    public void consume(boolean clear, InputStream inputStream) throws IOException {
        int chunk;
        if (clear) {
            this.clear();
        }
        this.ensureCapacity(this.currentBuffer.position() + inputStream.available());
        while ((chunk = inputStream.read(this.copyBuffer)) != -1) {
            this.ensureCapacity(this.currentBuffer.position() + chunk);
            this.currentBuffer.put(this.copyBuffer, 0, chunk);
        }
    }

    private void ensureCapacity(int capacity) {
        if (capacity > this.currentBuffer.capacity()) {
            ByteBuffer newBuffer = ByteBuffer.allocateDirect(this.currentBuffer.capacity() << 1);
            this.currentBuffer.flip();
            newBuffer.put(this.currentBuffer);
            this.currentBuffer = newBuffer;
        }
    }
}

