/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.tools;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class JsonBrowser {
    private static final ObjectMapper mapper = JsonBrowser.setupMapper();
    private final Object value;

    private JsonBrowser(Object value) {
        this.value = value;
    }

    public boolean isList() {
        return this.value instanceof List;
    }

    public boolean isMap() {
        return this.value instanceof Map;
    }

    public JsonBrowser index(int index) {
        if (this.value instanceof List) {
            return new JsonBrowser(((List)this.value).get(index));
        }
        throw new IllegalStateException("Index only works on a list");
    }

    public JsonBrowser get(Object key) {
        if (this.value instanceof Map) {
            return new JsonBrowser(((Map)this.value).get(key));
        }
        throw new IllegalStateException("Get only works on a map");
    }

    public JsonBrowser safeGet(Object key) {
        if (this.value instanceof Map) {
            return new JsonBrowser(((Map)this.value).get(key));
        }
        return new JsonBrowser(null);
    }

    public void put(String key, Object item) {
        if (!(this.value instanceof Map)) {
            throw new IllegalStateException("Put only works on a map");
        }
        ((Map)this.value).put(key, item);
    }

    public List<JsonBrowser> values() {
        ArrayList<JsonBrowser> values;
        block3: {
            block2: {
                values = new ArrayList<JsonBrowser>();
                if (!(this.value instanceof Map)) break block2;
                for (Object object : ((Map)this.value).values()) {
                    values.add(new JsonBrowser(object));
                }
                break block3;
            }
            if (!(this.value instanceof List)) break block3;
            for (Object object : (List)this.value) {
                values.add(new JsonBrowser(object));
            }
        }
        return values;
    }

    public <T> T as(Class<T> klass) {
        return mapper.convertValue(this.value, klass);
    }

    public String text() {
        return this.value != null ? this.value.toString() : null;
    }

    public boolean isNull() {
        return this.value == null;
    }

    public static JsonBrowser parse(String json) throws IOException {
        return new JsonBrowser(mapper.readValue(json, Object.class));
    }

    public static JsonBrowser parse(InputStream stream) throws IOException {
        return new JsonBrowser(mapper.readValue(stream, Object.class));
    }

    private static ObjectMapper setupMapper() {
        JsonFactory jsonFactory = new JsonFactory();
        jsonFactory.enable(JsonParser.Feature.ALLOW_COMMENTS);
        jsonFactory.enable(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES);
        return new ObjectMapper(jsonFactory);
    }
}

