/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.natives.vorbis;

import com.sedmelluq.discord.lavaplayer.natives.NativeResourceHolder;
import com.sedmelluq.discord.lavaplayer.natives.vorbis.VorbisDecoderLibrary;
import java.nio.ByteBuffer;

public class VorbisDecoder
extends NativeResourceHolder {
    private final VorbisDecoderLibrary library = VorbisDecoderLibrary.getInstance();
    private final long instance = this.library.create();
    private int channelCount = 0;

    public void parseHeader(ByteBuffer buffer, int length, boolean isBeginning) {
        this.checkNotReleased();
        if (!buffer.isDirect()) {
            throw new IllegalArgumentException("Buffer argument must be a direct buffer.");
        }
        if (buffer.remaining() < length) {
            throw new IllegalArgumentException("Cannot take more from buffer than available.");
        }
        int error = this.library.processHeader(this.instance, buffer, buffer.position(), length, isBeginning);
        buffer.position(buffer.position() + length);
        if (error != 0) {
            throw new IllegalStateException("Processing header failed with error " + error + ".");
        }
    }

    public void initialise() {
        this.checkNotReleased();
        if (!this.library.initialise(this.instance)) {
            throw new IllegalStateException("Could not initialise library.");
        }
        this.channelCount = this.library.getChannelCount(this.instance);
    }

    public int getChannelCount() {
        return this.channelCount;
    }

    public void input(ByteBuffer buffer) {
        this.checkNotReleased();
        if (!buffer.isDirect()) {
            throw new IllegalArgumentException("Buffer argument must be a direct buffer.");
        }
        int result = this.library.input(this.instance, buffer, buffer.position(), buffer.remaining());
        buffer.position(buffer.position() + buffer.remaining());
        if (result != 0) {
            throw new IllegalStateException("Passing input failed with error " + result + ".");
        }
    }

    public int output(float[][] channels) {
        this.checkNotReleased();
        if (channels.length != this.channelCount) {
            throw new IllegalStateException("Invalid channel float buffer length");
        }
        int result = this.library.output(this.instance, channels, channels[0].length);
        if (result < 0) {
            throw new IllegalStateException("Retrieving output failed");
        }
        return result;
    }

    @Override
    protected void freeResources() {
        this.library.destroy(this.instance);
    }
}

