/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.filter.volume;

import com.sedmelluq.discord.lavaplayer.filter.AudioPostProcessor;
import com.sedmelluq.discord.lavaplayer.filter.volume.AudioFrameVolumeChanger;
import com.sedmelluq.discord.lavaplayer.filter.volume.PcmVolumeProcessor;
import com.sedmelluq.discord.lavaplayer.track.playback.AudioProcessingContext;
import java.nio.ShortBuffer;

public class VolumePostProcessor
implements AudioPostProcessor {
    private final PcmVolumeProcessor volumeProcessor;
    private final AudioProcessingContext context;

    public VolumePostProcessor(AudioProcessingContext context) {
        this.context = context;
        this.volumeProcessor = new PcmVolumeProcessor(context.volumeLevel.get());
    }

    @Override
    public void process(long timecode, ShortBuffer buffer) throws InterruptedException {
        int currentVolume = this.context.volumeLevel.get();
        if (currentVolume != this.volumeProcessor.getLastVolume()) {
            AudioFrameVolumeChanger.apply(this.context);
        }
        if (currentVolume != 0) {
            this.volumeProcessor.applyVolume(100, currentVolume, buffer);
        } else {
            this.volumeProcessor.setLastVolume(0);
        }
    }

    @Override
    public void close() {
    }
}

