/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.filter.volume;

import java.nio.ShortBuffer;

public class PcmVolumeProcessor {
    private int currentVolume = -1;
    private int integerMultiplier;

    public PcmVolumeProcessor(int initialVolume) {
        this.setupMultipliers(initialVolume);
    }

    public int getLastVolume() {
        return this.currentVolume;
    }

    public void setLastVolume(int lastVolume) {
        this.currentVolume = lastVolume;
    }

    public void applyVolume(int initialVolume, int targetVolume, ShortBuffer buffer) {
        if (initialVolume != 100 && initialVolume != 0) {
            this.setupMultipliers(initialVolume);
            this.unapplyCurrentVolume(buffer);
        }
        this.setupMultipliers(targetVolume);
        this.applyCurrentVolume(buffer);
    }

    private void setupMultipliers(int activeVolume) {
        if (this.currentVolume != activeVolume) {
            this.currentVolume = activeVolume;
            float floatMultiplier = (float)Math.tan((float)activeVolume * 0.0079f);
            this.integerMultiplier = (int)(floatMultiplier * 10000.0f);
        }
    }

    private void applyCurrentVolume(ShortBuffer buffer) {
        if (this.currentVolume == 100) {
            return;
        }
        int endOffset = buffer.limit();
        for (int i = buffer.position(); i < endOffset; ++i) {
            int value = buffer.get(i) * this.integerMultiplier / 10000;
            buffer.put(i, (short)Math.max(-32767, Math.min(Short.MAX_VALUE, value)));
        }
    }

    private void unapplyCurrentVolume(ShortBuffer buffer) {
        if (this.integerMultiplier == 0) {
            return;
        }
        int endOffset = buffer.limit();
        for (int i = buffer.position(); i < endOffset; ++i) {
            int value = buffer.get(i) * 10000 / this.integerMultiplier;
            buffer.put(i, (short)Math.max(-32767, Math.min(Short.MAX_VALUE, value)));
        }
    }
}

