/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.filter;

import com.sedmelluq.discord.lavaplayer.filter.ShortPcmAudioFilter;
import java.nio.ShortBuffer;

public class ChannelCountPcmAudioFilter
implements ShortPcmAudioFilter {
    private final ShortPcmAudioFilter downstream;
    private final int outputChannels;
    private final ShortBuffer outputBuffer;
    private final int inputChannels;
    private final ShortBuffer inputSet;
    private int nextChannelIndex;
    private short lastSample;

    public ChannelCountPcmAudioFilter(int inputChannels, int outputChannels, ShortPcmAudioFilter downstream) {
        this.downstream = downstream;
        this.inputChannels = inputChannels;
        this.outputChannels = outputChannels;
        this.outputBuffer = ShortBuffer.allocate(2048 * inputChannels);
        this.inputSet = ShortBuffer.allocate(inputChannels);
        this.nextChannelIndex = 0;
    }

    @Override
    public void process(short[] input, int offset, int length) throws InterruptedException {
        if (this.canPassThrough(length)) {
            this.downstream.process(input, offset, length);
        } else if (this.inputChannels == 1 && this.outputChannels == 2) {
            this.processMonoToStereo(ShortBuffer.wrap(input, offset, length));
        } else {
            this.processNormalizer(ShortBuffer.wrap(input, offset, length));
        }
    }

    @Override
    public void process(ShortBuffer buffer) throws InterruptedException {
        if (this.canPassThrough(buffer.remaining())) {
            this.downstream.process(buffer);
        } else if (this.inputChannels == 1 && this.outputChannels == 2) {
            this.processMonoToStereo(buffer);
        } else {
            this.processNormalizer(buffer);
        }
    }

    private void processNormalizer(ShortBuffer buffer) throws InterruptedException {
        int commonChannels = Math.min(this.outputChannels, this.inputChannels);
        int channelsToAdd = this.outputChannels - commonChannels;
        while (buffer.hasRemaining()) {
            int i;
            this.inputSet.put(buffer.get());
            if (this.inputSet.hasRemaining()) continue;
            for (i = 0; i < commonChannels; ++i) {
                this.outputBuffer.put(this.inputSet.get());
            }
            for (i = 0; i < channelsToAdd; ++i) {
                this.outputBuffer.put(this.inputSet.get(0));
            }
            if (!this.outputBuffer.hasRemaining()) {
                this.outputBuffer.flip();
                this.downstream.process(this.outputBuffer);
                this.outputBuffer.clear();
            }
            this.inputSet.position(0);
        }
    }

    private void processMonoToStereo(ShortBuffer buffer) throws InterruptedException {
        while (buffer.hasRemaining()) {
            short sample = buffer.get();
            this.outputBuffer.put(sample);
            this.outputBuffer.put(sample);
            if (this.outputBuffer.hasRemaining()) continue;
            this.outputBuffer.flip();
            this.downstream.process(this.outputBuffer);
            this.outputBuffer.clear();
        }
    }

    private boolean canPassThrough(int length) {
        return this.inputSet.position() == 0 && this.inputChannels == this.outputChannels && length % this.inputChannels == 0;
    }

    @Override
    public void seekPerformed(long requestedTime, long providedTime) {
        this.downstream.seekPerformed(requestedTime, providedTime);
        this.outputBuffer.clear();
        this.nextChannelIndex = 0;
    }

    @Override
    public void flush() throws InterruptedException {
        this.downstream.flush();
    }

    @Override
    public void close() {
        this.downstream.close();
    }
}

