/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.container.playlists;

import com.sedmelluq.discord.lavaplayer.container.MediaContainerDetection;
import com.sedmelluq.discord.lavaplayer.container.MediaContainerDetectionResult;
import com.sedmelluq.discord.lavaplayer.container.MediaContainerHints;
import com.sedmelluq.discord.lavaplayer.container.MediaContainerProbe;
import com.sedmelluq.discord.lavaplayer.tools.DataFormatTools;
import com.sedmelluq.discord.lavaplayer.tools.io.SeekableInputStream;
import com.sedmelluq.discord.lavaplayer.track.AudioReference;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlsPlaylistContainerProbe
implements MediaContainerProbe {
    private static final Logger log = LoggerFactory.getLogger(PlsPlaylistContainerProbe.class);
    private static final int[] PLS_HEADER = new int[]{91, -1, 108, 97, 121, 108, 105, 115, 116, 93};
    private static Pattern filePattern = Pattern.compile("\\s*File([0-9]+)=((?:https?|icy)://.*)\\s*");
    private static Pattern titlePattern = Pattern.compile("\\s*Title([0-9]+)=(.*)\\s*");

    @Override
    public String getName() {
        return "pls";
    }

    @Override
    public boolean matchesHints(MediaContainerHints hints) {
        return false;
    }

    @Override
    public MediaContainerDetectionResult probe(AudioReference reference, SeekableInputStream inputStream) throws IOException {
        if (!MediaContainerDetection.checkNextBytes(inputStream, PLS_HEADER)) {
            return null;
        }
        log.debug("Track {} is a PLS playlist file.", (Object)reference.identifier);
        return this.loadFromLines(DataFormatTools.streamToLines(inputStream, StandardCharsets.UTF_8));
    }

    private MediaContainerDetectionResult loadFromLines(String[] lines) {
        HashMap<String, String> trackFiles = new HashMap<String, String>();
        HashMap<String, String> trackTitles = new HashMap<String, String>();
        for (String line : lines) {
            Matcher fileMatcher = filePattern.matcher(line);
            if (fileMatcher.matches()) {
                trackFiles.put(fileMatcher.group(1), fileMatcher.group(2));
                continue;
            }
            Matcher titleMatcher = titlePattern.matcher(line);
            if (!titleMatcher.matches()) continue;
            trackTitles.put(titleMatcher.group(1), titleMatcher.group(2));
        }
        Iterator iterator = trackFiles.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            String title = (String)trackTitles.get(entry.getKey());
            return new MediaContainerDetectionResult((MediaContainerProbe)this, new AudioReference((String)entry.getValue(), title != null ? title : "Unknown title"));
        }
        return new MediaContainerDetectionResult((MediaContainerProbe)this, "The playlist file contains no links.");
    }

    @Override
    public AudioTrack createTrack(AudioTrackInfo trackInfo, SeekableInputStream inputStream) {
        throw new UnsupportedOperationException();
    }
}

