/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.container.playlists;

import com.sedmelluq.discord.lavaplayer.container.MediaContainerDetection;
import com.sedmelluq.discord.lavaplayer.container.MediaContainerDetectionResult;
import com.sedmelluq.discord.lavaplayer.container.MediaContainerHints;
import com.sedmelluq.discord.lavaplayer.container.MediaContainerProbe;
import com.sedmelluq.discord.lavaplayer.tools.DataFormatTools;
import com.sedmelluq.discord.lavaplayer.tools.io.SeekableInputStream;
import com.sedmelluq.discord.lavaplayer.track.AudioReference;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class M3uPlaylistContainerProbe
implements MediaContainerProbe {
    private static final Logger log = LoggerFactory.getLogger(M3uPlaylistContainerProbe.class);
    private static final int[] M3U_HEADER_TAG = new int[]{35, 69, 88, 84, 77, 51, 85};
    private static final int[] M3U_ENTRY_TAG = new int[]{35, 69, 88, 84, 73, 78, 70};

    @Override
    public String getName() {
        return "m3u";
    }

    @Override
    public boolean matchesHints(MediaContainerHints hints) {
        return false;
    }

    @Override
    public MediaContainerDetectionResult probe(AudioReference reference, SeekableInputStream inputStream) throws IOException {
        if (!MediaContainerDetection.checkNextBytes(inputStream, M3U_HEADER_TAG) && !MediaContainerDetection.checkNextBytes(inputStream, M3U_ENTRY_TAG)) {
            return null;
        }
        log.debug("Track {} is an M3U playlist file.", (Object)reference.identifier);
        return this.loadFromLines(DataFormatTools.streamToLines(inputStream, StandardCharsets.UTF_8));
    }

    private MediaContainerDetectionResult loadFromLines(String[] lines) {
        String trackTitle = null;
        for (String line : lines) {
            if (line.startsWith("#EXTINF")) {
                trackTitle = this.extractTitleFromInfo(line);
                continue;
            }
            if (line.startsWith("#") || line.length() <= 0) continue;
            if (line.startsWith("http://") || line.startsWith("https://") || line.startsWith("icy://")) {
                return new MediaContainerDetectionResult((MediaContainerProbe)this, new AudioReference(line.trim(), trackTitle));
            }
            trackTitle = null;
        }
        return new MediaContainerDetectionResult((MediaContainerProbe)this, "The playlist file contains no links.");
    }

    private String extractTitleFromInfo(String infoLine) {
        String[] splitInfo = infoLine.split(",", 2);
        return splitInfo.length == 2 ? splitInfo[1] : null;
    }

    @Override
    public AudioTrack createTrack(AudioTrackInfo trackInfo, SeekableInputStream inputStream) {
        throw new UnsupportedOperationException();
    }
}

