/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.container.ogg;

import com.sedmelluq.discord.lavaplayer.container.common.OpusPacketRouter;
import com.sedmelluq.discord.lavaplayer.container.ogg.OggPacketInputStream;
import com.sedmelluq.discord.lavaplayer.container.ogg.OggTrackProvider;
import com.sedmelluq.discord.lavaplayer.tools.io.DirectBufferStreamBroker;
import com.sedmelluq.discord.lavaplayer.track.playback.AudioProcessingContext;
import java.io.IOException;
import java.nio.ByteBuffer;

public class OggOpusTrackProvider
implements OggTrackProvider {
    private static final int HEAD_TAG_HALF = ByteBuffer.wrap(new byte[]{72, 101, 97, 100}).getInt();
    private final OggPacketInputStream packetInputStream;
    private final DirectBufferStreamBroker broker;
    private OpusPacketRouter opusPacketRouter;

    public OggOpusTrackProvider(OggPacketInputStream packetInputStream, DirectBufferStreamBroker broker) {
        this.packetInputStream = packetInputStream;
        this.broker = broker;
    }

    @Override
    public void initialise(AudioProcessingContext context) throws IOException {
        ByteBuffer buffer = this.broker.getBuffer();
        if (buffer.getInt(4) != HEAD_TAG_HALF) {
            throw new IllegalStateException("First packet is not an OpusHead.");
        }
        int channelCount = buffer.get(9) & 0xFF;
        int sampleRate = Integer.reverseBytes(buffer.getInt(12));
        this.opusPacketRouter = new OpusPacketRouter(context, sampleRate, channelCount);
        if (!this.packetInputStream.startNewPacket()) {
            throw new IllegalStateException("No OpusTags packet in track.");
        }
        this.broker.consume(true, this.packetInputStream);
    }

    @Override
    public void provideFrames() throws InterruptedException {
        try {
            while (this.packetInputStream.startNewPacket()) {
                this.broker.consume(true, this.packetInputStream);
                ByteBuffer buffer = this.broker.getBuffer();
                if (buffer.remaining() <= 0) continue;
                this.opusPacketRouter.process(buffer);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void seekToTimecode(long timecode) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        if (this.opusPacketRouter != null) {
            this.opusPacketRouter.close();
        }
    }
}

