/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.container.mpegts;

import com.sedmelluq.discord.lavaplayer.tools.io.BitBufferReader;
import com.sedmelluq.discord.lavaplayer.tools.io.GreedyInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class MpegTsElementaryInputStream
extends InputStream {
    public static final int ADTS_ELEMENTARY_STREAM = 15;
    private static final int PID_UNKNOWN = -1;
    private static final int PID_NOT_PRESENT = -2;
    private static final int TS_PACKET_SIZE = 188;
    private final InputStream inputStream;
    private final int elementaryDataType;
    private final byte[] packet;
    private final ByteBuffer packetBuffer;
    private final BitBufferReader bufferReader;
    private int elementaryStreamIdentifier;
    private int programMapIdentifier;
    private boolean elementaryDataInPacket;
    private boolean streamEndReached;

    public MpegTsElementaryInputStream(InputStream inputStream, int elementaryDataType) {
        this.inputStream = new GreedyInputStream(inputStream);
        this.elementaryDataType = elementaryDataType;
        this.packet = new byte[188];
        this.packetBuffer = ByteBuffer.wrap(this.packet);
        this.bufferReader = new BitBufferReader(this.packetBuffer);
        this.elementaryStreamIdentifier = -1;
        this.programMapIdentifier = -1;
    }

    @Override
    public int read() throws IOException {
        if (!this.findElementaryData()) {
            return -1;
        }
        int result = this.packetBuffer.get() & 0xFF;
        this.checkElementaryDataEnd();
        return result;
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        if (!this.findElementaryData()) {
            return -1;
        }
        int chunk = Math.min(length, this.packetBuffer.remaining());
        this.packetBuffer.get(buffer, offset, chunk);
        this.checkElementaryDataEnd();
        return chunk;
    }

    private boolean findElementaryData() throws IOException {
        if (!this.elementaryDataInPacket) {
            while (this.processPacket()) {
                if (!this.elementaryDataInPacket) continue;
                return true;
            }
        }
        return this.elementaryDataInPacket;
    }

    private void checkElementaryDataEnd() {
        if (this.packetBuffer.remaining() == 0) {
            this.elementaryDataInPacket = false;
        }
    }

    private boolean processPacket() throws IOException {
        if (!this.isContinuable()) {
            return false;
        }
        if (this.inputStream.read(this.packet) < this.packet.length) {
            this.streamEndReached = true;
            return false;
        }
        this.packetBuffer.clear();
        this.bufferReader.readRemainingBits();
        int identifier = MpegTsElementaryInputStream.verifyPacket(this.bufferReader, this.packetBuffer);
        if (identifier == -1) {
            return false;
        }
        this.processPacketContent(identifier);
        return this.isContinuable();
    }

    private void processPacketContent(int identifier) {
        if (identifier == 0 || identifier == this.programMapIdentifier) {
            if (identifier == 0) {
                this.programMapIdentifier = -2;
            }
            this.processProgramPacket();
        } else if (identifier == this.elementaryStreamIdentifier) {
            this.elementaryDataInPacket = true;
        }
    }

    private boolean isContinuable() {
        return !this.streamEndReached || this.programMapIdentifier != -2 && this.elementaryStreamIdentifier != -2;
    }

    private void processProgramPacket() {
        int tableIdentifier;
        this.discardPointerField();
        while (this.packetBuffer.hasRemaining() && (tableIdentifier = this.packetBuffer.get() & 0xFF) != 255) {
            int sectionInfo = this.bufferReader.asInteger(6);
            int sectionLength = this.bufferReader.asInteger(10);
            int position = this.packetBuffer.position();
            this.bufferReader.readRemainingBits();
            if (tableIdentifier == 0) {
                this.processPatTable(sectionInfo);
            } else if (tableIdentifier == 2) {
                this.processPmtTable(sectionInfo, sectionLength);
            }
            this.packetBuffer.position(position + sectionLength);
        }
    }

    private boolean processPatPmtCommon(int sectionInfo) {
        if (sectionInfo != 44) {
            return false;
        }
        this.bufferReader.asLong(40);
        return true;
    }

    private void processPatTable(int sectionInfo) {
        if (!this.processPatPmtCommon(sectionInfo)) {
            return;
        }
        this.bufferReader.asLong(16);
        if (this.bufferReader.asLong(3) == 7L) {
            this.programMapIdentifier = this.bufferReader.asInteger(13);
        }
    }

    private void processPmtTable(int sectionInfo, int sectionLength) {
        int endPosition = this.packetBuffer.position() + sectionLength;
        if (!this.processPatPmtCommon(sectionInfo) || this.bufferReader.asInteger(3) != 7) {
            return;
        }
        this.bufferReader.asLong(13);
        if (this.bufferReader.asLong(6) != 60L) {
            return;
        }
        int programInfoLength = this.bufferReader.asInteger(10);
        this.packetBuffer.position(this.packetBuffer.position() + programInfoLength);
        this.processElementaryStreams(endPosition);
    }

    private void processElementaryStreams(int endPosition) {
        this.elementaryStreamIdentifier = -2;
        while (this.packetBuffer.position() < endPosition - 4) {
            int streamType = this.bufferReader.asInteger(8);
            this.bufferReader.asInteger(3);
            int streamPid = this.bufferReader.asInteger(13);
            this.bufferReader.asLong(6);
            int infoLength = this.bufferReader.asInteger(10);
            this.packetBuffer.position(this.packetBuffer.position() + infoLength);
            if (streamType != this.elementaryDataType) continue;
            this.elementaryStreamIdentifier = streamPid;
        }
    }

    private void discardPointerField() {
        int pointerField = this.packetBuffer.get();
        for (int i = 0; i < pointerField; ++i) {
            this.packetBuffer.get();
        }
    }

    private static int verifyPacket(BitBufferReader reader, ByteBuffer rawBuffer) {
        if (reader.asLong(8) != 71L) {
            return -1;
        }
        reader.asLong(3);
        int identifier = reader.asInteger(13);
        long scrambling = reader.asLong(2);
        long adaptation = reader.asLong(2);
        if (scrambling != 0L) {
            return -1;
        }
        reader.asLong(4);
        if (adaptation == 2L || adaptation == 3L) {
            int adaptationSize = reader.asInteger(8);
            rawBuffer.position(rawBuffer.position() + adaptationSize);
        }
        return identifier;
    }
}

