/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.container;

import com.sedmelluq.discord.lavaplayer.container.MediaContainer;
import com.sedmelluq.discord.lavaplayer.container.MediaContainerDetectionResult;
import com.sedmelluq.discord.lavaplayer.container.MediaContainerHints;
import com.sedmelluq.discord.lavaplayer.tools.ExceptionTools;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.tools.io.GreedyInputStream;
import com.sedmelluq.discord.lavaplayer.tools.io.SavedHeadSeekableInputStream;
import com.sedmelluq.discord.lavaplayer.tools.io.SeekableInputStream;
import com.sedmelluq.discord.lavaplayer.track.AudioReference;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediaContainerDetection {
    public static final String UNKNOWN_TITLE = "Unknown title";
    public static final String UNKNOWN_ARTIST = "Unknown artist";
    public static final int STREAM_SCAN_DISTANCE = 1000;
    private static final Logger log = LoggerFactory.getLogger(MediaContainerDetection.class);
    private static final int HEAD_MARK_LIMIT = 1024;

    public static MediaContainerDetectionResult detectContainer(AudioReference reference, SeekableInputStream inputStream, MediaContainerHints hints) {
        MediaContainerDetectionResult result;
        try {
            SavedHeadSeekableInputStream savedHeadInputStream = new SavedHeadSeekableInputStream(inputStream, 1024);
            savedHeadInputStream.loadHead();
            result = MediaContainerDetection.detectContainer(reference, savedHeadInputStream, hints, true);
            if (result == null) {
                result = MediaContainerDetection.detectContainer(reference, savedHeadInputStream, hints, false);
            }
        }
        catch (Exception e) {
            throw ExceptionTools.wrapUnfriendlyExceptions("Could not read the file for detecting file type.", FriendlyException.Severity.SUSPICIOUS, e);
        }
        return result != null ? result : new MediaContainerDetectionResult();
    }

    private static MediaContainerDetectionResult detectContainer(AudioReference reference, SeekableInputStream inputStream, MediaContainerHints hints, boolean matchHints) throws IOException {
        boolean checked = false;
        for (MediaContainer container : (MediaContainer[])MediaContainer.class.getEnumConstants()) {
            if (matchHints != container.probe.matchesHints(hints)) continue;
            inputStream.seek(0L);
            MediaContainerDetectionResult result = MediaContainerDetection.checkContainer(container, reference, inputStream);
            if (result != null) {
                return result;
            }
            checked = true;
        }
        return checked ? new MediaContainerDetectionResult() : null;
    }

    private static MediaContainerDetectionResult checkContainer(MediaContainer container, AudioReference reference, SeekableInputStream inputStream) {
        try {
            return container.probe.probe(reference, inputStream);
        }
        catch (Exception e) {
            log.warn("Attempting to detect file with container {} failed.", (Object)container.name(), (Object)e);
            return null;
        }
    }

    public static boolean checkNextBytes(SeekableInputStream stream, int[] match) throws IOException {
        return MediaContainerDetection.checkNextBytes(stream, match, true);
    }

    public static boolean checkNextBytes(SeekableInputStream stream, int[] match, boolean rewind) throws IOException {
        long position = stream.getPosition();
        boolean result = true;
        for (int matchByte : match) {
            int inputByte = stream.read();
            if (inputByte != -1 && (matchByte == -1 || matchByte == inputByte)) continue;
            result = false;
            break;
        }
        if (rewind) {
            stream.seek(position);
        }
        return result;
    }

    public static boolean matchNextBytesAsRegex(SeekableInputStream stream, int distance, Pattern pattern, Charset charset) throws IOException {
        long position = stream.getPosition();
        byte[] bytes = new byte[distance];
        int read = new GreedyInputStream(stream).read(bytes);
        stream.seek(position);
        if (read == -1) {
            return false;
        }
        String text = new String(bytes, 0, read, charset);
        return pattern.matcher(text).find();
    }
}

